ProductionPointLeasing = {}

source(g_currentModDirectory .. "ProductionLeasingEvent.lua")

function ProductionPointLeasing:loadMap(name)
    ProductionPointLeasing.LeaseTitlePrefix = "(Leasing) "

    if g_currentMission:getIsServer() or g_currentMission.isMasterUser then
        g_messageCenter:subscribe(MessageType.DAY_CHANGED, self.DayChanged, self)
    end

    g_messageCenter:subscribe(BuyExistingPlaceableEvent, ProductionPointLeasing.MapButtonsFix)
end

function ProductionPointLeasing:MapButtonsFix()

    local function TryBlock()
        if ProductionPointLeasing.IngameMap ~= nil then
            local spot = ProductionPointLeasing.IngameMap.currentHotspot
            ProductionPointLeasing.IngameMap:setMapSelectionItem(nil)
            ProductionPointLeasing.IngameMap:setMapSelectionItem(spot)
        end
    end
    
    pcall(TryBlock) 
end

function ProductionPointLeasing:DayChanged()
    local ProductionBuildings = ProductionPointLeasing:GetAllProductionBuildings()

    for i = 1, table.getn(ProductionBuildings) do
        local storeItem = g_storeManager:getItemByXMLFilename(ProductionBuildings[i].configFileName)
        local price = g_currentMission.economyManager:getBuyPrice(storeItem) or ProductionBuildings[i]:getPrice()

        local price = price / 365

        g_currentMission:addMoney(-price, ProductionBuildings[i]:getOwnerFarmId(), MoneyType.PRODUCTION_COSTS, true)
    end
end

function ProductionPointLeasing:GetAllProductionBuildings()
    roductionBuildings = {}
    for i = #g_currentMission.placeableSystem.placeables, 1, -1 do
        local Cplaceable = g_currentMission.placeableSystem.placeables[i]
        if
            Cplaceable ~= nil and Cplaceable.spec_productionPoint and
                string.find(Cplaceable:getName(), ProductionPointLeasing.LeaseTitlePrefix, 1, true)
         then
            roductionBuildings[table.getn(roductionBuildings) + 1] = Cplaceable
        end
    end
    return roductionBuildings
end

function ProductionPointLeasing:ProductionPointBuyRequest(super, ...)
    if self.mission:getFarmId() == 0 then
        return
    end

    local dialog = g_gui:showDialog("OptionDialog")

    local args = {
        text = g_i18n:getText("text_BuyOrLeaseDesc"),
        title = g_i18n:getText("text_BuyOrLease"),
        options = {
            g_i18n:getText("text_Buy"),
            g_i18n:getText("text_Lease")
        },
        args = {"B", "L"},
        callback = function(sel)
            if sel == 1 then
                return super(self)
            end

            if sel == 2 then
                ProductionPointLeasing:ProductionPointLeasingRequest(self.owningPlaceable, self)
            end
        end
    }

    dialog.target:setText(args.text)
    dialog.target:setTitle(args.title)
    dialog.target:setOptions(args.options)
    dialog.target:setCallback(args.callback, args.target, args.args)
    dialog.target:setButtonTexts(args.okText)
end

function ProductionPointLeasing:ProductionPointLeasingRequest(PlaceableToLease, ScreenInstance)
    local storeItem = g_storeManager:getItemByXMLFilename(PlaceableToLease.configFileName)
    local price = g_currentMission.economyManager:getBuyPrice(storeItem) or PlaceableToLease:getPrice()

    local price = price / 365

    local args = {
        text = string.gsub(
            string.gsub(g_i18n:getText("text_LeaseDesc"), "#", g_i18n:formatMoney(price, 0, true, true)),
            "@",
            PlaceableToLease:getName()
        ),
        title = g_i18n:getText("text_LeaseTitle"),
        callback = function(yes)
            if not yes then
                return
            end

            ProductionPointLeasing:StartLeasing(PlaceableToLease, ScreenInstance)
        end
    }

    local dialog = g_gui:showDialog("YesNoDialog")
    dialog.target:setText(args.text)
    dialog.target:setTitle(args.title)
    dialog.target:setDialogType(Utils.getNoNil(args.dialogType, DialogElement.TYPE_QUESTION))
    dialog.target:setCallback(args.callback, args.target, args.args)
    dialog.target:setButtonTexts(args.yesText, args.noText)
    dialog.target:setButtonSounds(args.yesSound, args.noSound)
end

function ProductionPointLeasing:ValidateSellButton(PlaceableToValidate)
    local function createBtn(prefab, text, callback)
        local btn = prefab:clone(prefab.parent)
        btn:setText(text)
        btn:setVisible(false)
        btn:setCallback("onClickCallback", callback)
        btn:setInputAction(InputAction.MENU_CANCEL)
        btn.parent:invalidateLayout()
        return btn
    end

    if self.CancelLeasingButton == nil then
        self.CancelLeasingButton =
            createBtn(self.sellButton, g_i18n:getText("text_CancelLease"), "onClickCancelLeasing")
    end

    if
        string.sub(PlaceableToValidate:getName(), 1, #ProductionPointLeasing.LeaseTitlePrefix) ==
            ProductionPointLeasing.LeaseTitlePrefix and
            PlaceableToValidate:getOwnerFarmId() == g_currentMission:getFarmId()
     then
        self.sellButton:setVisible(false)
        self.renameButton:setVisible(false)
        self.CancelLeasingButton:setVisible(true)
        self.sellButton.parent:invalidateLayout()
    else
        self.CancelLeasingButton:setVisible(false)
    end
end

function ProductionPointLeasing:onClickCancelLeasing()
    local args = {
        text = g_i18n:getText("text_CancelLeaseDesc"),
        title = g_i18n:getText("text_CancelLease"),
        callback = function(yes)
            if not yes then
                return
            end

            if ProductionPointLeasing.MapHotspotLeasingTemp == nil then
                ProductionPointLeasing:StopLeasing(self)
            else
                ProductionPointLeasing:StopLeasing(ProductionPointLeasing.MapHotspotLeasingTemp)
            end
        end
    }

    local dialog = g_gui:showDialog("YesNoDialog")
    dialog.target:setText(args.text)
    dialog.target:setTitle(args.title)
    dialog.target:setDialogType(Utils.getNoNil(args.dialogType, DialogElement.TYPE_QUESTION))
    dialog.target:setCallback(args.callback, args.target, args.args)
    dialog.target:setButtonTexts(args.yesText, args.noText)
    dialog.target:setButtonSounds(args.yesSound, args.noSound)
end

function ProductionPointLeasing:StartLeasing(PlaceableToLease, ScreenInstance)
    g_client:getServerConnection():sendEvent(
        ProductionLeasingEvent.new(PlaceableToLease, ScreenInstance.mission:getFarmId(), true)
    )

    ScreenInstance:openMenu()
end

function ProductionPointLeasing:StopLeasing(Context)
    g_client:getServerConnection():sendEvent(
        ProductionLeasingEvent.new(Context.placeable, Context.placeable:getOwnerFarmId(), false)
    )
    if Context.onClickBack ~= nil then
        Context:onClickBack()
    else
        if ProductionPointLeasing.IngameMap ~= nil then
            local spot = ProductionPointLeasing.IngameMap.currentHotspot
            ProductionPointLeasing.IngameMap:setMapSelectionItem(nil)
            ProductionPointLeasing.IngameMap:setMapSelectionItem(spot)
        end

        ProductionPointLeasing.MapHotspotLeasingTemp = nil
        ProductionPointLeasing.MapHotspotLeasing = nil
    end
end

PlaceableInfoDialog.onClickCancelLeasing =
    Utils.prependedFunction(PlaceableInfoDialog.onClickCancelLeasing, ProductionPointLeasing.onClickCancelLeasing)
PlaceableInfoDialog.setPlaceable =
    Utils.appendedFunction(PlaceableInfoDialog.setPlaceable, ProductionPointLeasing.ValidateSellButton)
ProductionPoint.buyRequest =
    Utils.overwrittenFunction(ProductionPoint.buyRequest, ProductionPointLeasing.ProductionPointBuyRequest)

function ProductionPointLeasing:MapHotspotSelected(Selected)
    if self.placeable == nil then
        return
    end

    if
        string.sub(self.placeable:getName(), 1, #ProductionPointLeasing.LeaseTitlePrefix) ==
            ProductionPointLeasing.LeaseTitlePrefix and self.placeable:getOwnerFarmId() == g_currentMission:getFarmId()
     then
        if Selected then
            ProductionPointLeasing.MapHotspotLeasing = self
        else
            ProductionPointLeasing.MapHotspotLeasing = nil
        end
    end
end

function ProductionPointLeasing:ShowGuiDialog(super, ...)
    if ProductionPointLeasing.MapHotspotLeasing ~= nil then
        ProductionPointLeasing.MapHotspotLeasingTemp = ProductionPointLeasing.MapHotspotLeasing
        ProductionPointLeasing.MapHotspotLeasing = nil
        ProductionPointLeasing:onClickCancelLeasing(ProductionPointLeasing.MapHotspotLeasingTemp)
        ProductionPointLeasing.MapHotspotLeasing = ProductionPointLeasing.MapHotspotLeasingTemp
        return nil
    end

    return super(self, ...)
end

function ProductionPointLeasing:IngameMapLoad()
    ProductionPointLeasing.IngameMap = self
end

Gui.showDialog = Utils.overwrittenFunction(Gui.showDialog, ProductionPointLeasing.ShowGuiDialog)
MapHotspot.setSelected = Utils.prependedFunction(MapHotspot.setSelected, ProductionPointLeasing.MapHotspotSelected)
InGameMenuMapFrame.onLoadMapFinished =
    Utils.prependedFunction(InGameMenuMapFrame.onLoadMapFinished, ProductionPointLeasing.IngameMapLoad)

addModEventListener(ProductionPointLeasing)
